<!doctype html>
<html lang="fr">
<head>
  <meta charset="utf-8">
  <meta name="Description" content="Buy My Cle - Reproduction de clé automobile perdue ou cassée, toutes marques confondues" />
  <meta property="og:title" content="buymycle.com - Reproduction et Réparation de vos clé de voiture, toutes marques confondues" />
  <meta property="og:description" content="Des clés cassées, perdues? Ou vous avez besoin d'en créer des doubles? Buy My Cle est la solution de reproduction de toutes vos clés." />
  <meta property="og:url" content="//www.buymycle.com/"/>
  <meta property="og:locale" content="fr_FR" />
  <meta property="og:image" content="//www.buymycle.com/images/cle-perdue-cassee.jpg" />
  <meta property="og:type" content="website" />
  <meta property="og:site_name" content="Buy My Cle" />
  <title>Buy My Cle - Reproduction et Réparation de vos clé de voiture, toutes marques confondues</title>
  <link rel="stylesheet" href="css/style.css">
  <link href="//fonts.googleapis.com/css?family=Anton|Open+Sans" rel="stylesheet">
  <link rel="stylesheet" href="//use.fontawesome.com/releases/v5.0.13/css/all.css" integrity="sha384-DNOHZ68U8hZfKXOrtjWvjxusGo9WQnrNx2sqG0tfsghAvtVlRW3tvkXWZh58N9jp" crossorigin="anonymous">
  <link rel="icon" type="image/x-icon" href="favicon.ico" />
  <meta content="width=device-width, initial-scale=1.0" name="viewport" />
</head>
<body>
	<header>
		<div class="Content">
			<div class="colG">
				<ul>
					<li class="inline-block">
						<img src="images/horaire.png" alt="Nos horaires d'ouverture" />
					</li>
					<li class="inline-block">
						Du lundi au samedi<br/>de 09h00 à 20h00
					</li>
				</ul>
			</div>
			<div class="colD">
				<ul>
					<li class="inline-block">
						<img src="images/phone.png" alt="Notre numéro de téléphone" />
					</li>
					<li class="inline-block">
						01 83 92 76 78
					</li>
				</ul>
			</div>
		</div>
	</header>
	<div class="row row1">
		<div class="Content">
			<img src="images/BuyMyCle.png" alt="BuyMyCle - Faite reproduire ou réparer vos clés de voiture, toutes marques confondues" class="logo" />
			<div class="txt">
				<h1 class="bgBlack">
				Des clés perdues ou cassées ?
				</h1>
				<h2>
					BuyMyCle est la solution
				</h2>
				<ul>
					<li class="inline-block">
						<button id="Reproduire">
							Reproduire une clé <i class="fas fa-angle-right"></i>
						</button>
					</li>
					<li class="inline-block">
						<button id="Refaire">
							Refaire une clé <i class="fas fa-angle-right"></i>
						</button>
					</li>
				</ul>
			</div>
		</div>
	</div>
	<div class="row2">
		<div class="Content">
			<h2>
				Parce que sans clé, plus de voiture
			</h2>
			<img src="images/cle-voiture2.jpg" alt="Une clé de voiture" class="Visiblexs" />
			<div class="colG">
				<h3>
					Reproduction <br class="Dnone" />de toutes les marques
				</h3>
				<p>
					Nous reproduisons, les clés automobiles de toutes les marques et nous les programmons avec le système d’ouverture électronique et l’antidémarrage du véhicule. Votre double de clé sera identique à la clé d’origine et parfaitement adapté à vos serrures.
				</p>
			</div>
			<div class="colM">
				<img src="images/cle-voiture.jpg" alt="Une clé de voiture" />
			</div>
			<div class="colD">
				<h3>
					Dépannage rapide <br class="Dnone" />pour votre clé de voiture perdue
				</h3>
				<p>
					Nous intervenons rapidement avec tout notre matériel sur place. Une fois le véhicule ouvert et le neiman accessible, nous fabriquons une nouvelle clé identique à celle d’origine. Dans certains cas, une programmation électronique de la clé est nécessaire pour l’antidémarrage.
				</p>
			</div>
		</div>
	</div>
	<div class="row row3">
		<div class="Content">
			<ul class="inline-block">
				<li>
					<img src="images/reproduction-tous-marques.png" alt="Toutes les marques" />
				</li>
				<li>
					<p>
						Reproduction<br/> toutes marques
					</p>
				</li>
			</ul>
			<hr class="miniBorder"/>
			<ul class="inline-block">
				<li>
					<img src="images/intervention24h.png" alt="Intervention 24h" />
				</li>
				<li>
					<p>
						Intervention<br/> en 1 journée
					</p>
				</li>
			</ul>
			<hr class="miniBorder"/>
			<ul class="inline-block">
				<li>
					<img src="images/intervention-domicile.png" alt="Intervention Domicile" />
				</li>
				<li>
					<p>
						Intervention<br/> sur place ou à domicile
					</p>
				</li>
			</ul>
			<hr class="miniBorder"></hr>
			<ul class="inline-block">
				<li>
					<img src="images/pas-de-frais.png" alt="Pas de frais" />
				</li>
				<li>
					<p>
						Pas de frais<br/> de remorquage
					</p>
				</li>
			</ul>
		</div>
	</div>
	<div class="row row4" id="formulaire">
		<div class="Content">
			<h3>
				Demandez votre devis gratuit !
			</h3>
			<div class="colG">
				<p>Par mail</p>
				<a href="mailto:buymycle@gmail.com" class="mail">
					buymycle@gmail.com
				</a>
				<p>
					Nous vous répondrons<br/> dans les plus brefs délais !
				</p>

			</div>
			<div class="colD">
				<p>
					Ou par téléphone
				</p>
				<p class="numero">
					01 83 92 76 78
				</p>
				<p>
					Du lundi au samedi<br/>de 09h00 à 20h00
				</p>
			</div>
		</div>	
	</div>
	<div class="row row4bis">
		<h3>Où nous retrouver ?</h3>
		<div class="colG">
			<img src="images/map.png" alt="Où nous retrouver?" />
		</div>
		<div class="colD">
			53 rue Claude Decaen - 75012 Paris<br/>
			Métro <img src="images/ligne8.png" alt="8" class="inline-block" /> : Michel Bizot
		</div>

	</div>
	<div class="GMap txt-center">
		<iframe src="//www.google.com/maps/embed?pb=!1m14!1m8!1m3!1d2626.1401210691165!2d2.3963369!3d48.8364659!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x47e6726873b6e947%3A0xfd1b7466eb81992f!2s53+Rue+Claude+Decaen%2C+75012+Paris!5e0!3m2!1sfr!2sfr!4v1531498246462" width="600" height="450" frameborder="0" style="border:0" allowfullscreen></iframe>
	</div>	
		
	<div class="row row5">
		<div class="Content">
			<ul>
				<li class="title">
					<h3>
						Un savoir-faire<br/> sur toutes les marques
					</h3>
				</li>
				<li>
					<img src="images/honda.png" alt="Voiture marque Honda">
				</li>
				<li>
					<img src="images/ford.png" alt="Voiture marque Ford">
				</li>
				<li>
					<img src="images/bmw.png" alt="Voiture marque BMW">
				</li>
				<li>
					<img src="images/mercedes-benz.png" alt="Voiture marque Mercedes Benz">
				</li>
				<li>
					<img src="images/harley-davinson.png" alt="Moto Harley Davinson">
				</li>
				<li>
					<img src="images/suzuki.png" alt="Voiture marque Suziki">
				</li>
				<li>
					<img src="images/toyota.png" alt="Voiture marque Toyota">
				</li>
				<li>
					<img src="images/yamaha.png" alt="Voiture marque Yamaha">
				</li>
				<li>
					<img src="images/audi.png" alt="Voiture marque Audi">
				</li>
				<li>
					<img src="images/dacia.png" alt="Voiture marque Dacia">
				</li>
				<li>
					<img src="images/peugeot.png" alt="Voiture marque Peugeot">
				</li>
				<li>
					<img src="images/renault.png" alt="Voiture marque Renault">
				</li>
				<li>
					<img src="images/citroen.png" alt="Voiture marque Citroen">
				</li>
				<li>
					<img src="images/volkswagen.png" alt="Voiture marque Volkswagen">
				</li>
				<li>
					<img src="images/nissan.png" alt="Voiture marque Nissan">
				</li>
				<li>
					<img src="images/fiat.png" alt="Voiture marque Fiat">
				</li>
			</ul>
			<button id="contact">
					Nous contacter <i class="fas fa-angle-right"></i>
			</button>
		</div>
	</div>
	<footer>
		<div class="Content">
			<div class="colG">
				<p>
					Copyright © 2018
				</p>
			</div>
		</div>
	</footer>
<script src="//ajax.googleapis.com/ajax/libs/jquery/1.10.2/jquery.min.js"></script>
<script src="js/jquery-1.11.1.min.js"></script>
<script src="js/script.js" type="text/javascript"></script>
</body>
</html>